﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.WebUI.Admin.Helpers;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin
{
    public partial class Ei8htPOS : System.Web.UI.MasterPage
    {
        protected List<decimal> MonthlySales;
        protected List<int> MonthlyOrders;

        protected void Page_Load(object sender, EventArgs e)
        {
            //if (!IsPostBack)
            //{
               
            //}
            if (WebSession.CurrentAdminUser != null)
            {
                lblUserName.Text = string.Format("{0} {1}", WebSession.CurrentAdminUser.FirstName, WebSession.CurrentAdminUser.LastName);
                if (!WebSession.CurrentAdminUser.UserRoleType.ToLower().Equals("superadmin"))
                    UserMenu.Visible = false;
                Bindproduct();
            }
            Bindproduct();
        }

        protected void Logout_Click(object sender, EventArgs e)
        {
            WebSession.CurrentAdminUser = null;
            Response.Redirect("~/Admin/Default.aspx", false);
        }

        private void Bindproduct()
        {
            MonthlySales = new List<decimal> { };
            MonthlyOrders = new List<int> { };
            List<Orders> pcList = new List<Orders>();
            for (int i = 5; i >= 0; i--)
            {
            pcList = OrdersBL.GetList(Guid.Empty, Guid.Empty, string.Empty, ReturnFirstDayOfMonth(i), ReturnLastDayOfMonth(i));
            if (pcList != null && pcList.Count > 0)
            {
                pcList = pcList.Where(a => a.IsActive).ToList<Orders>();
            }
            MonthlySales.Add(pcList.Sum(a => a.PaidAmount));
            MonthlyOrders.Add(pcList.Count);
            }
            lblMonthlyOrders.Text = pcList.Count.ToString();
            lblWeekSales.Text = pcList.Sum(a => a.PaidAmount).ToString("$0.00");
            
        }

        

        public void ExportToExcel<T>(GridView gv,string Filename)
        {
            int PageSize = gv.PageSize;
            Response.ClearContent();
            Response.ContentType = "application/ms-excel";
            Response.AddHeader("content-disposition", string.Format("attachment; filename={0}_{1}.xls",Filename,DateTime.Now.ToString("MMM_dd")));
            gv.AllowPaging = false;
            if (gv.DataSource is IList<T>)
            {
                List<T> entityList = (List<T>)gv.DataSource;
                gv.PageSize = (entityList != null && entityList.Any()) ? entityList.Count : PageSize;
                gv.DataBind();
            }
            else if (gv.DataSource is DataTable)
            {
                DataTable dt = gv.DataSource as DataTable;
                gv.PageSize = (dt != null && dt.Rows != null) ? dt.Rows.Count : PageSize;
                gv.DataBind();
            }
            StringWriter sw = ExportHelper.Export<T>(gv);
            gv.AllowPaging = true;
            gv.PageSize = PageSize;
            gv.DataBind();
            Response.Output.Write(sw.ToString());
            Response.Flush();
            Response.End();
        }

        public DateTime ReturnFirstDayOfMonth(int MonthsToAdd)
        {
            return new DateTime(DateTime.Now.AddMonths(-MonthsToAdd).Year, DateTime.Now.AddMonths(-MonthsToAdd).Month, 1);
        }

        public DateTime ReturnLastDayOfMonth(int MonthsToAdd)
        {
            return new DateTime(DateTime.Now.AddMonths(-MonthsToAdd).Year, DateTime.Now.AddMonths(-MonthsToAdd).Month, DateTime.DaysInMonth(DateTime.Now.AddMonths(-MonthsToAdd).Year,DateTime.Now.AddMonths(-MonthsToAdd).Month));
        }

    }
}